# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 8
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR8_strategy.txt
# LLM Suggested Fallback: C

def benevolent_specter(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early Game: Cooperate unconditionally
    if current_round <= 3:
        return "C"
    
    # Mid-Game: Test opponent's response
    elif current_round <= 7:
        if all(move == "C" for move in opp_history[:3]):
            if current_round == 4:
                return "D"
            elif current_round == 5:
                return "D" if opp_history[3] == "C" else "C"
            elif current_round == 6:
                return "C" if opp_history[4] == "C" else "D"
            elif current_round == 7:
                return "D" if opp_history[5] == "D" else "C"
        else:
            return opp_history[-1]
    
    # Late Game: Adapt based on opponent's behavior
    else:
        if opp_history.count("D") > 2:
            return opp_history[-1]
        else:
            return "D" if current_round >= 9 else "C"